;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;2010/04/28     Modify the macro "%InitialIO"
;==========================================================================
        .PAGE0
R_IntTempA:             .DS     1
R_IntTempX:             .DS     1
R_IntTempY:             .DS     1
;==========================================================================
;Purpose: Initialize system status
;Input: None
;Return: None
;Destroy: A, X, SP
;==========================================================================
%InitialSystem:         .MACRO
        LDA     #00H
        STA     P_NMI_Disable           ;Disable NMI
        STA     P_INT_CtrlL             ;Initialize interrupt control
        STA     P_INT_CtrlH             ;Initialize interrupt control
        STA     P_SPU_Enable            ;Disable SPU
        STA     P_SPU_IntCtrl           ;Disable SPU IRQ

        LDX     #FFH
        TXS
        STX     P_SPU_Status            ;Clear SPU IRQ sttus
        STX     P_INT_StatusL           ;Clear interrupt status register
        STX     P_INT_StatusH           ;Clear interrupt status register
                        .ENDM
;==========================================================================
;Purpose: Clear RAM of defined range
;Input: Start address of RAM, End address of RAM
;Return: None
;Destroy: A, X
;==========================================================================
%ClearRAM:              .MACRO  Start, End
        LDX     #00H
        TXA
L_ClearAllRAM#:
        STA     Start,X
        CPX     #.LOW.End
        BEQ     L_ClrRamOK#
        INX
        BNE     L_ClearAllRAM#
L_ClrRamOK#:
                        .ENDM
;==========================================================================
;Purpose: Set the main volume and output swing of SPU (Full/Half)
;Input: Main volume of SPU
;Return: None
;Destroy: A
;==========================================================================
%SetUpMainVol:          .MACRO  MainVol
        LDA     #MainVol

        .IF FullSwing = ON
        ORA     #D_Bit7
        .ELSE
        AND     #~D_Bit7
        .ENDIF

        STA     P_MainVol
                        .ENDM
;==========================================================================
;Purpose: Set the digital mixer of SPU
;Input: Mixer channels of SPU
;Return: None
;Destroy: A
;==========================================================================
%SetUpMixer:            .MACRO  Mixer
        LDA     #Mixer
        STA     P_Mixer
                        .ENDM
;==========================================================================
;Purpose: Set the gain control of push-pull DAC
;Input: Gain control level (00H ~ 0FH)
;Return: None
;Destroy: A
;==========================================================================
%SetGainCtrl:           .MACRO  Gain
        LDA     P_DAC_Ctrl
        AND     #11110000B
        ORA     #Gain
        STA     P_DAC_Ctrl
                        .ENDM
;==========================================================================
;Purpose: Check if designated SPU channel is busy
;Input: Channel number (GPCD3: 0; GPCD6: 0 ~ 3; GPCD9: 0 ~ 7)
;Return: Selected channel is idle if C flag is 0; selected channel is busy if C flag is 1
;Destroy: A, X
;==========================================================================
%TestChBusy:            .MACRO  Channel
        CLC
        LDX     #Channel
        LDA     P_SPU_Enable

        .IF     D_ChannelNo = 1
        AND     #00000001B
        .ENDIF

        .IF     D_ChannelNo = 4
        AND     #00001111B
        .ENDIF

        .IF     D_ChannelNo = 8
        AND     #11111111B
        .ENDIF

        AND     T_ChEnable,X
        BEQ     L_Exit?
        SEC
L_Exit?:
                        .ENDM
;==========================================================================
;Purpose: Check if any SPU channel is busy
;Input: None
;Return: C = 0, no channel is busy; C = 1, certain channel is busy
;Destroy: A
;==========================================================================
%TestAnyChBusy:         .MACRO
        CLC
        LDA     P_SPU_Enable

        .IF     D_ChannelNo = 1
        AND     #00000001B
        .ENDIF

        .IF     D_ChannelNo = 4
        AND     #00001111B
        .ENDIF

        .IF     D_ChannelNo = 8
        AND     #11111111B
        .ENDIF

        BEQ     L_Exit?
        SEC                             ;C = 1, SPU is busy
L_Exit?:
                        .ENDM
;==========================================================================
;Purpose: Initialize all I/O ports as input pull-low
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%InitialIO:             .MACRO
        LDA     #00H

        STA     P_IOA_Att               ;Set IOA as input pull-low
        STA     P_IOA_Dir
        STA     P_IOA_Buf

        STA     P_IOB_Att               ;Set IOB as input pull-low
        STA     P_IOB_Dir
        STA     P_IOB_Buf

        .IFDEF  P_IOC_Data
        STA     P_IOC_Att               ;Set IOC as input pull-low
        STA     P_IOC_Dir
        STA     P_IOC_Buf
        .ENDIF

        .IFDEF  P_IOD_Data
        STA     P_IOD_Att               ;Set IOD as input pull-low
        STA     P_IOD_Dir
        STA     P_IOD_Buf
        .ENDIF
                        .ENDM
;==========================================================================
;Purpose: Backup register A, X and Y to RAM
;Input: None
;Return: None
;Destroy: None
;==========================================================================
%PushAll:               .MACRO
        STA     R_IntTempA
        STX     R_IntTempX
        STY     R_IntTempY
                        .ENDM
;==========================================================================
;Purpose: Restore register A, X and Y from RAM
;Input: None
;Return: None
;Destroy: A, X, Y
;==========================================================================
%PopAll:                .MACRO
        LDY     R_IntTempY
        LDX     R_IntTempX
        LDA     R_IntTempA
                        .ENDM
;==========================================================================
